/*= DIGISTANT 4462 ===========================================================*/
/*																				*/
/*  LabWindows Instrument Driver Version CVI 5.0.1                            	*/
/*  for Burster Digistant Typ 4462												*/
/*  Original Release: 	1.0 	Date: 2000.02.21                              	*/
/*  File Name:			bp4462.h												*/
/*  By: Thomas Meder                                                          	*/
/*  Originally written in C                                                   	*/
/*																				*/
/*  Modification History: 12.06.2002 by T. Meder 	Release 2.0           		*/
/*    The following functions were extended with parameter 'version' which is	*/
/*    a Flag for the new 60 Volts Digistant 4462 device Version					*/
/*		- bp4462_SetCalConfVolt													*/
/*		- bp4462_SetConfigRamp1													*/
/*		- bp4462_SetConfigListRamp2												*/
/*		- bp4462_SetConfigOutputStatus											*/
/* 		- bp4462_SetConfigOutputLimitV											*/
/*		- bp4462_SetConfigOutputLimitC											*/
/*		- bp4462_SetStoreIdOutputValue											*/
/*		- bp4462_SetConfigRangeMode												*/
/*		- bp4462_SetConfigDeltaValue											*/
/*																				*/
/*  Modification History: 14.11.2003 by T. Meder 	Release 2.1           		*/
/*    The temperature output constant values of K, C and F were changed.		*/
/*											*/
/*  Modification History: 24.08.2004 by T. Meder 	Release 2.2           		*/
/*    Changed Variable names because of consolidated compiler restrictions.		*/
/*==============================================================================*/

#include <vpptype.h>
/*== defines for serial communication =========================*/
#define NUL      0x00
#define STX      0x02
#define ETX      0x03
#define EOT      0x04
#define ENQ      0x05
#define ACK      0x06
#define CR       0x0D
#define NAK      0x15

/*== defines for program=======================================*/

#define bp4462_GPIB        		0
#define bp4462_SERIAL      		1

#define bp4462_EOC	  			(1<<8)	 		/* Bit 8 of Operation Status Register */

#define bp4462_MAX_INSTR   		30

#define bp4462_MAX_CMD     		100	  			/* normal 300? */

#define bp4462_MIN_UV	  		-30000000.0		/* max/min Voltage range */ 
#define bp4462_MAX_UV	   		30000000.0

#define bp4462_MIN_MV     		-30000.0
#define bp4462_MAX_MV      		30000.0

#define bp4462_MIN30_V      		-30.0	       
#define bp4462_MAX30_V       		30.0
#define bp4462_MIN60_V      		-60.0	       
#define bp4462_MAX60_V       		60.0

#define bp4462_MIN30_UA     		-52000.0		/* max/min Current range */
#define bp4462_MAX30_UA      		52000.0
#define bp4462_MIN60_UA     		-22000.0		/* max/min Current range 60 Volt version*/
#define bp4462_MAX60_UA      		22000.0

#define bp4462_MIN30_MA     		-52.0			/* max/min Current range */
#define bp4462_MAX30_MA      		52.0
#define bp4462_MIN60_MA     		-22.0			/* max/min Current range */
#define bp4462_MAX60_MA      		22.0

#define bp4462_MIN_K       		3.15			/* max/min Teperature range */
#define bp4462_MAX_K      		2588.14	

#define bp4462_MIN_GRD_C   		-270.00
#define bp4462_MAX_GRD_C  		2314.99	

#define bp4462_MIN_GRD_F   		-453.99
#define bp4462_MAX_GRD_F  		4198.98	

#define bp4462_MIN_RJ_K       	223.15			/* max/min Teperature range */
#define bp4462_MAX_RJ_K      	423.15	

#define bp4462_MIN_RJ_GRD_C   	-50.0
#define bp4462_MAX_RJ_GRD_C  	150.0	

#define bp4462_MIN_RJ_GRD_F   	-58.0
#define bp4462_MAX_RJ_GRD_F  	302.0	

/*======= Deltavalues ==========*/ 
 
#define bp4462_MIN30_d_UV     	0.0		   
#define bp4462_MAX30_d_UV     	60000000.0		/* valid delta voltage range */
#define bp4462_MIN60_d_UV     	0.0		   
#define bp4462_MAX60_d_UV     	120000000.0		/* valid delta voltage range */

#define bp4462_MIN30_d_MV     	0.0		   
#define bp4462_MAX30_d_MV     	60000.0
#define bp4462_MIN60_d_MV     	0.0		   
#define bp4462_MAX60_d_MV     	120000.0

#define bp4462_MIN30_d_V      	0.0		   
#define bp4462_MAX30_d_V      	60.0
#define bp4462_MIN60_d_V      	0.0		   
#define bp4462_MAX60_d_V      	120.0

#define bp4462_MIN30_d_UA     	0.0		   		/* valid delta current range */
#define bp4462_MAX30_d_UA     	104000.0
#define bp4462_MIN60_d_UA     	0.0		   		/* valid delta current range */
#define bp4462_MAX60_d_UA     	44000.0

#define bp4462_MIN30_d_MA     	0.0		   		
#define bp4462_MAX30_d_MA     	104.0
#define bp4462_MIN60_d_MA     	0.0		   		
#define bp4462_MAX60_d_MA     	44.0

#define bp4462_MIN_d_GRD_C	  	0				/* valid delta temperature range */ 
#define bp4462_MAX_d_GRD_C    	3000

#define bp4462_MIN_d_GRD_F  	0
#define bp4462_MAX_d_GRD_F  	5400
 
#define bp4462_MIN_d_K		 	0
#define bp4462_MAX_d_K		 	3000

/*======= Limitvalues ===========*/

#define bp4462_MIN_limit_V      	1		    /* valid limit voltage range */
#define bp4462_MAX30_limit_V      	32
#define bp4462_MAX60_limit_V      	62

#define bp4462_MIN_limit_MA     	1		   	/* valid limit current range */
#define bp4462_MAX30_limit_MA     	55
#define bp4462_MAX60_limit_MA     	24

/*======= Bit-defines ==========*/

#define bp4462_OPERATION_COMPLETE   	(1<<0) /* Bit 0 of Standard Event Status Register */
#define bp4462_QUERY_ERROR   			(1<<2) /* Bit 2 of Standard Event Status Register */ 
#define bp4462_DEVICE_DEPENDENT_ERROR  	(1<<3) /* Bit 3 of Standard Event Status Register */ 
#define bp4462_EXECUTION_ERROR   		(1<<4) /* Bit 4 of Standard Event Status Register */ 
#define bp4462_COMMAND_ERROR   			(1<<5) /* Bit 5 of Standard Event Status Register */ 

#define bp4462_VOLTAGE_ERROR   			(1<<0) /* Bit 0 of Questionable Status Register */   
#define bp4462_CURRENT_ERROR   			(1<<1) /* Bit 1 of Questionable Status Register */   
#define bp4462_POWER_ERROR   	        (1<<3) /* Bit 3 of Questionable Status Register */   
#define bp4462_TEMPERATURE_ERROR		(1<<4) /* Bit 4 of Questionable Status Register */   
#define bp4462_CALIBRATION_ERROR   		(1<<8) /* Bit 8 of Questionable Status Register */   
#define bp4462_PT100_ERROR   			(1<<9) /* Bit 9 of Questionable Status Register */ 

#define bp4462_CURR_WIRE_ERROR   		(1<<0) /* Bit 0 of Questionable Status Temperature Register */ 
#define bp4462_VOLT_WIRE_ERROR   		(1<<1) /* Bit 1 of Questionable Status Temperature Register */ 
#define bp4462_PT100_OVERRANGE		   	(1<<2) /* Bit 2 of Questionable Status Temperature Register */ 
#define bp4462_INVALID_TEMERATURE  		(1<<3) /* Bit 3 of Questionable Status Temperature Register */ 

#define bp4462_OUTPUT_OVERRANGE_ERROR   (1<<0) /* Bit 0 of Questionable Status Output Register */ 
#define bp4462_PT100_OUTP_ERROR   		(1<<3) /* Bit 3 of Questionable Status Output Register */ 
#define bp4462_DA_DEVICE_OVERRANGE_ERROR (1<<4) /* Bit 4 of Questionable Status Output Register */ 

#define bp4462_CALEBRATING_STATE 		(1<<0) /* Bit 0 of Operation Status Register */ 
#define bp4462_CAL_MEASURE_FLAG 		(1<<8) /* Bit 8 of Operation Status Register */ 


/*== GLOBAL FUNCTION DECLARATIONS bp4462.C=========================================*/
  									
int _VI_FUNC bp4462_InitSerial (int com_port, int baud_rate ,int data_config,
 								int reset_flag, int *instr_ID);
int _VI_FUNC  bp4462_InitGpib (int address, int reset, int *instr_ID);
int _VI_FUNC bp4462_SetConfigRamp1 (int instr_ID, int wave, int number, int step_time_h, 
								int step_time_min, double step_time_sec, int type, 
								double step, double start_value, double end_value, int version);
int _VI_FUNC bp4462_GetConfigRamp1(int instr_ID, int* wave, int* number, 
					int* step_time_h, int* step_time_min, double* step_time_sec,
					int* step_unit, double* step_value, int* start_unit, 
					double* start_value, int* stop_unit, double* stop_value);
int _VI_FUNC bp4462_SetConfigRamp2 (int instr_ID, int waveform,int number,int points, int list);
int _VI_FUNC bp4462_GetConfigRamp2(int instr_ID, int list, int *waveform, int *count, int* points);
int _VI_FUNC bp4462_SetConfigListRamp2 (int instr_ID, int type,int list_no,double value,int step_time_h,
								int step_time_min, double step_time_sec, int version);
int _VI_FUNC bp4462_GetConfigListRamp2 (int instr_ID, int list_no, int* type, double* value,
								int* step_time_h, int* step_time_min, double* step_time_sec);
int _VI_FUNC bp4462_SetRampStart (int instr_ID, int start_mode);
int _VI_FUNC bp4462_SetRampStep (int instr_ID, int smode);
int _VI_FUNC bp4462_SetConfigRangeMode (int instr_ID, int mode, int version);
int _VI_FUNC bp4462_GetConfigRangeMode (int instr_ID, int *mode);
int _VI_FUNC bp4462_SetRjTempValueMan (int instr_ID, int unit, double value);
int _VI_FUNC bp4462_GetRjTempValueMan (int instr_ID, int *unit, double* value);
int _VI_FUNC bp4462_SetConfigRjType (int instr_ID, int type);
int _VI_FUNC bp4462_GetConfigRjType (int instr_ID, int *type);
int _VI_FUNC bp4462_GetRjTempValue (int instr_ID, int *unit, double* value);
int _VI_FUNC bp4462_GetTcVoltageExtern (int instr_ID, double* voltage_ut, int unit_ut, 
										double* voltage_u0, int unit_u0);
int _VI_FUNC bp4462_SetConfigTc (int instr_ID, int typ, int scale, int unit);
int _VI_FUNC bp4462_GetConfigTc (int instr_ID, int* typ, int* scale, int* unit);
int _VI_FUNC bp4462_SetConfigTcUnit(int instr_ID, int unit);
int _VI_FUNC bp4462_SetConfigCoefficient (int instr_ID, double r0, double a, double b, double c, double t100);
int _VI_FUNC bp4462_GetConfigCoefficient (int instr_ID, double* r0, double* a, double* b, double* c, double* t100);
int _VI_FUNC bp4462_GetConfigDinCoefficient (int instr_ID, double* r0, double* a, double* b, double* c, double* t100);
int _VI_FUNC bp4462_SetConfigOutputLimitC (int instr_ID, int current_limit, int version);
int _VI_FUNC bp4462_SetConfigOutputLimitV (int instr_ID, int voltage_limit, int version);
int _VI_FUNC bp4462_GetConfigOutputLimit (int instr_ID, int* voltage_limit, int* current_limit);
int _VI_FUNC bp4462_SetConfigOutputStatus (int instr_ID, int type, double value, int version);
int _VI_FUNC bp4462_GetConfigOutputStatus (int instr_ID, int* type, double* value);
int _VI_FUNC bp4462_SetConfigOutputMode (int instr_ID, int mode);
int _VI_FUNC bp4462_GetConfigOutputMode (int instr_ID, int *mode);
int _VI_FUNC bp4462_SetConfigSense (int instr_ID, int sense);
int _VI_FUNC bp4462_GetConfigSense (int instr_ID, int* sense);
int _VI_FUNC bp4462_SetConfigDisplayMode (int instr_ID, int d_mode);
int _VI_FUNC bp4462_SetConfigDisplayContrast (int instr_ID, double contrast);
int _VI_FUNC bp4462_GetConfigDisplayContrast (int instr_ID, double* contrast);
int _VI_FUNC bp4462_SetConfigDeviceAccess(int instr_ID, int speech, int output_m,int ramp_mode,
								int ramp_1, int ramp_2,int delta_v, int store_config,
								int recallonfig,int sense, int outputlimit,int rangemode, 
								int divide, int TC_config, int RJ_config, int PT100_scale,
								int device_store, int device_recall,int interf, 
								int contrast,int status_display);
int _VI_FUNC bp4462_GetConfigDeviceAccess(int instr_ID, int* speech, int* output_m, int* ramp_mode,
								int* ramp1, int* ramp2, int* delta_v, 
								int* store_config, int* recall_config,int* sense,
								int* output_limit, int* range_mode, int* devide,
								int* TC_config,int* RJ_config,int* PT100_scale, 
								int* device_store,int* device_recall, int* interf,
								int* contrast, int* status_display);
int _VI_FUNC bp4462_SetConfigVoltageDiv (int instr_ID, double factor);
int _VI_FUNC bp4462_SetConfigVoltageDivState (int instr_ID, int mode); 
int _VI_FUNC bp4462_GetConfigVoltageDivState (int instr_ID, int* mode, double* factor);
int _VI_FUNC bp4462_SetConfigDeltaValue(int instr_ID, int type, double value, int version);
int _VI_FUNC bp4462_GetConfigDeltaValue (int instr_ID, int type, int* unit, double* value);
int _VI_FUNC bp4462_SetAddDeltaValue (int instr_ID, int mode);

int _VI_FUNC bp4462_send_scpi (int instr_ID, char* send_buffer);  
int _VI_FUNC bp4462_receive_scpi (int instr_ID, char* send_buffer,char* receive_buffer);
int _VI_FUNC bp4462_SetLockSystemKeyboard (int instr_ID, int flag);
int _VI_FUNC  bp4462_GetLockSystemKeyboard (int instr_ID, int *state);
int _VI_FUNC bp4462_GetSystemError (int instr_ID);
int _VI_FUNC bp4462_CheckTcOption (int ID_bp4462, int* tc_option); 

int _VI_FUNC bp4462_SetStoreOutputValue (int instr_ID, int store_id);
int _VI_FUNC bp4462_GetStoreOutputValue (int instr_ID, int store_id, int* output_unit, double* output_value, 
								int* delta_unit, double* delta_value);
int _VI_FUNC bp4462_SetStoreIdOutputValue (int instr_ID, int number, int output_type, 
					   			double output_value, int delta_type, double delta_value, int version);
int _VI_FUNC bp4462_GetMemoryLabel (int instr_ID, int mem_no,char* label);
int _VI_FUNC bp4462_SetMemoryLabel (int instr_ID, int mem_no, char label);
int _VI_FUNC bp4462_close (int);

/*----- Register Functions -----*/

int _VI_FUNC  bp4462_CheckErrorStatusTemp (int instr_ID);   
int _VI_FUNC  bp4462_CheckErrorStatusSource (int instr_ID);
int _VI_FUNC  bp4462_CheckErrorStatusOutput (int instr_ID);
int _VI_FUNC  bp4462_ReadStdEventStatusReg(int instr_ID, int* status, int* bit0, 
											int* bit2, int* bit3, int* bit4, int* bit5);
int _VI_FUNC  bp4462_ReadQuestStatusEventReg(int instr_ID, int* status, int* bit0, 
											int* bit1, int* bit3, int* bit4, int* bit8, int* bit9);
int _VI_FUNC  bp4462_ReadQuestStatusTempReg (int instr_ID, int* status, int* bit0, 
											int* bit1, int* bit2, int* bit3);
int _VI_FUNC  bp4462_ReadQuestStatusOutputReg (int instr_ID, int* status, int* bit0, 
												int* bit3, int* bit4);
int _VI_FUNC  bp4462_ReadOperStatusCondReg(int instr_ID, int* status, int* bit0, int* bit8);
int _VI_FUNC  bp4462_ReadOperStatusEventReg(int instr_ID, int* status, int* bit0, int* bit8);
int _VI_FUNC  bp4462_ResetQuestOperStEnReg(int instr_ID);

